//
//  YHTravelDocsPreparationTipsCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHTravelDocsPreparationTipsCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHTravelDocsPreparationTipsCell"
    static let cellH: CGFloat = (16 + 24) + 16 + (kMargin * 2 + YHTravelDocsPreparationTipsCell.tipsImageVH)
    private static let tipsImageVH: CGFloat = (404.0/307) * (KScreenWidth - kMargin * 2 - 18 * 2)
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        view.backgroundColor = .white
        return view
    }()
    
    lazy var tipsImageView: UIImageView = {
        let imageV: UIImageView = UIImageView()
        imageV.contentMode = .scaleAspectFill
        imageV.image = UIImage(named: "travelTips")// 307 404
        return imageV
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
}

private extension YHTravelDocsPreparationTipsCell {
    func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "办理逗留D签注注意事项"
        contentView.addSubview(label)
        label.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.equalToSuperview().offset(11)
            make.height.equalTo(24)
        }
        
        let tagView = UIView()
        tagView.backgroundColor = .brandMainColor
        contentView.addSubview(tagView)
        tagView.snp.makeConstraints { make in
            make.centerY.equalTo(label.snp.centerY)
            make.left.equalToSuperview()
            make.height.equalTo(12)
            make.width.equalTo(3)
        }
        
        contentView.addSubview(whiteContentView)
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(label.snp.bottom).offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHTravelDocsPreparationTipsCell.tipsImageVH + kMargin * 2)
        }
        
        whiteContentView.addSubview(tipsImageView)
        tipsImageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.equalToSuperview().offset(kMargin)
            make.width.equalTo(KScreenWidth - 2 * (18 + kMargin))
            make.height.equalTo(YHTravelDocsPreparationTipsCell.tipsImageVH)
        }
    }
}
